/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.loadmyresources.pack;

import de.keksuccino.loadmyresources.LoadMyResources;
import java.io.File;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;

public class PackHandler {
    public static final String PACK_NAME = "loadmyresources.hiddenpack";
    public static final int PACK_FORMAT = 8;
    public static final String PACK_DESCRIPTION = "LMR Resources";
    public static final ResourceLocation DUMMY_PACK_META = new ResourceLocation("loadmyresources", "dummy.pack.mcmeta");
    public static File resourcesDirectory = new File("resources/");

    public static void init() {
        if (LoadMyResources.config != null) {
            resourcesDirectory = new File(LoadMyResources.config.getOrDefault("resource_path", "resources/"));
        } else {
            LoadMyResources.LOGGER.error("[LOAD MY RESOURCES] ERROR: Config not loaded! Can't get resource path! Path set to default 'resources/'!");
        }
        LoadMyResources.LOGGER.info("[LOAD MY RESOURCES] PackHandler initialized!");
    }

    public static void prepareResourcesFolder() {
        if (!resourcesDirectory.isDirectory()) {
            resourcesDirectory.mkdirs();
        }
    }

    public static Pack createPack(String name, PackMetadataSection meta, boolean forceEnablePack, Supplier<PackResources> packSupplier, Pack.PackConstructor constructor, Pack.Position position, PackSource source) {
        try {
            Pack pack = null;
            try (PackResources res = packSupplier.get();){
                pack = constructor.create(name, (Component)new TextComponent(res.m_8017_()), forceEnablePack, packSupplier, meta, position, source, res.isHidden());
            }
            return pack;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

